library(quantmod)
getSymbols("IBM",src='yahoo')
a<-dailyReturn(IBM)
colnames(a)<-"RET"
getSymbols("^GSPC",src='yahoo')
b<-dailyReturn(GSPC)
colnames(b)<-"MKT_RET"
z<-merge(a,b)
head(z,2)
final<-merge(z,IBM)
head(final,2)
#
myLag<- function(x, k) {
  if (k>0) {
    return (c(rep(NA, k), x)[1 : length(x)] );
  }
  else {
    return (c(x[(-k+1) : length(x)], rep(NA, -k)));
  }
}
#
z<-final[1:20,]
y<-as.numeric(z$RET)-as.numeric(z$MKT_RET)
x1<-myLag(y,1)
x2<-sign(x1)*z$IBM.Close*z$IBM.Volume
x<-cbind(xl,x2)
lm(y~x)


Call:
lm(formula = y ~ x)

Coefficients:
(Intercept)         xRET   xIBM.Close  
 -5.849e-20    1.000e+00   -3.144e-28  



